return function(DateStringFormatter)

DateStringFormatter.shortFormat       = {}
DateStringFormatter.mediumFormat      = {}
DateStringFormatter.longFormat        = {}

function DateStringFormatter:boolean(showDate, showTime)
    local dateFormat = (showDate and DateStringFormatter.mediumFormat) or nil
    local timeFormat = (showTime and DateStringFormatter.shortFormat) or nil
    return DateStringFormatter:simple(dateFormat, timeFormat)
end

local _formatters = {}
local function _getIndex(b1, b2)
    local result = 0
    if b1 then
        result = result + 1
    end
    if b2 then
        result = result + 2
    end
    return result
end

function DateStringFormatter:deferredPattern()
    return {
        format = function(self, date, pattern)
            pattern = tostring(pattern)
            if pattern then
                local key = 'P:' .. pattern
                local formatter = _formatters[key] or DateStringFormatter:pattern(pattern)
                if formatter then
                    _formatters[key] = formatter
                    return formatter:format(date)
                end
            end
        end
    }
end

function DateStringFormatter:deferredTemplate()
    return {
        format = function(self, date, template)
            template = tostring(template)
            if template then
                local key = 'T:' .. template
                local formatter = _formatters[key] or DateStringFormatter:template(template)
                if formatter then
                    _formatters[key] = formatter
                    return formatter:format(date)
                end
            end
        end
    }
end

end
